/*! \file 
**********************************************************************************
*Title:                        Discretix Secured Clock Toolkit ATP Test source file
*
* Filename:                    TLK_SCLK_ATP_SecureClk_ Toolkit_Authenticate.c
*
* 
* Created:                      11.03.2009
*
* 
* \Author                      Liron Dror
*
* \Remarks
*           Copyright (C) 2009 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/

/************* Include Files ***********************************/
#include "DX_VOS_Mem.h"

#include "tlk_sclk_api.h"
#include "tlk_sclk_api_types.h"
#include "tlk_sclk_api_errors.h"

#include "MW_ATP_UTIL_funcs.h"
#include "MW_ATP_defines.h"

#include "TLK_SCLK_TST_UTIL.h"
#include "TLK_SCLK_ATP_Defines.h"
#include "TLK_SCLK_ATP_data.h"
#include "TLK_SCLK_ATP_tests.h"

#include "CRYS_HASH.h"
#include "DX_VOS_Thread.h"

/*****************************************************************************
* Function Name:
*  TLK_SCLK_ATP_Authenticate.
* 
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
*  To test Toolkit API TLK_SCLK_ServiceClkAuthenticate. 
*  The test calls to the API TLK_SCLK_ServiceClkAuthenticate and see that the returned parameters are as expected.
*
* Algorithm:
* 1.	Call TLK_SCLK_ServiceClkGen. 
* 2.	Call TLK_SCLK_MCServiceClkRevalidate with ServiceClockDrift.
* 3.	Call TLK_SCLK_ServiceClkAuthenticate.
* 4.	returned parameters are as expected.
*	 a.	Compare the service clock cookie with the returned cookie. 
*	 b.	Compare the service clock offset with the returned offset. 
******************************************************************************/
DxError_t TLK_SCLK_ATP_Authenticate (void)
{
	DxError_t                             TST_Error;
	TLK_SCLK_ServiceClockDescriptor_t     TST_ServiceDes;
	TLK_SCLK_ServiceClockTime_t           TST_ServiceNewTime;
	TLK_SCLK_ApplicationId_t              TST_gApplicationId = {1234};
	TLK_SCLK_ReadPermission_t             TST_g_ReadPermission_t = TLK_SCLK_WORLD_READABLE;
	TLK_SCLK_TimeFormat_t                 TST_gTimeFormat;
	DxTime_t                              TST_gmaxAllowedDriftIn0_1Seconds = 0x10;
	DxTime_t                              TST_g_wrong_maxAllowedDriftIn0_1Seconds = -1;
	DxTime_t                              TST_gmaximumRevalidationPeriod =5;
	DxTime_t                              TST_g_wrong_maximumRevalidationPeriod = -1;
	DxUint8_t                             TST_serviceClkPwd[4];
	DxUint32_t                            TST_serviceClkPwdLen = 3;
	TLK_SCLK_Cookie_t                     TST_return_cookie;
	DxUint32_t                            TST_serviceClkOffset_ptr;
#ifdef SCLK_ON_SEP
  DxUint32_t 						   timeAddress;
  DxTime_t                 TST_SystemTimeInSeconds;
#endif

	TST_Error = DX_VOS_MemCpy(TST_serviceClkPwd,TST_serviceClkPwdLen,"PWD",3);

	TST_ATP_CHECK_ERROR_RETURN(TST_Error,"DX_VOS_MemCpy","TLK_SCLK_ATP_Authenticate","");

	TST_gTimeFormat=TLK_SCLK_SECONDS_SINCE_FORMAT;


	ATP_LOG_TST_PRINT((MW_ATP_MSG," *******************************************************\n"));
	ATP_LOG_TST_PRINT((MW_ATP_MSG," **             TLK_SCLK_ATP_Authenticate Test        **\n"));     
	ATP_LOG_TST_PRINT((MW_ATP_MSG," *******************************************************\n \n"));


	/*	1.	Call TLK_SCLK_ServiceClkGen. */
	TST_Error = TLK_SCLK_ServiceClkGen( &TST_ServiceDes,
										&TST_gApplicationId,
										TST_gmaxAllowedDriftIn0_1Seconds,
										TST_gmaximumRevalidationPeriod,
										TST_g_ReadPermission_t,
										TST_serviceClkPwd,
										TST_serviceClkPwdLen,
										TST_gWorkSpace,
										TST_gWorkSpaceSizeInBytes);

	TST_ATP_CHECK_ERROR_RETURN(TST_Error,"TLK_SCLK_ServiceClkGen","TLK_SCLK_ATP_Authenticate","");

	/* 2.  Call TLK_SCLK_MCServiceClkRevalidate with the system time.*/
	MW_TST_Util_GetTime(&TST_ServiceNewTime.secondsSinceFormat);
#ifdef SCLK_ON_SEP
	TST_SystemTimeInSeconds = TST_ServiceNewTime.secondsSinceFormat;
	TST_ServiceNewTime.secondsSinceFormat = TST_SystemTimeInSeconds + 0x100;
#else
	TST_ServiceNewTime.secondsSinceFormat += 0x100;
#endif

	TST_Error = TLK_SCLK_ServiceClkRevalidate(  &TST_ServiceDes,
												&TST_gApplicationId,
												&TST_ServiceNewTime,
												TST_gTimeFormat,
												TST_serviceClkPwd,
												TST_serviceClkPwdLen,
												TST_gWorkSpace,
												TST_gWorkSpaceSizeInBytes);

	TST_ATP_CHECK_ERROR_RETURN(TST_Error,"TLK_SCLK_ServiceClkRevalidate","TLK_SCLK_ATP_Authenticate","");

	/* 3.Call TLK_SCLK_ServiceClkAuthenticate.*/
	
	TST_Error = TLK_SCLK_ServiceClkAuthenticate(&TST_ServiceDes,
												&TST_gApplicationId,
												TST_serviceClkPwd,
												TST_serviceClkPwdLen,
												TST_return_cookie,
												&TST_serviceClkOffset_ptr,
												TST_gWorkSpace,
												TST_gWorkSpaceSizeInBytes);

	TST_ATP_CHECK_ERROR_RETURN(TST_Error,"TLK_SCLK_ServiceClkAuthenticate","TLK_SCLK_ATP_Authenticate","");
	
	/* 4.	returned parameters are as expected.*/
	/*	 a.	Compare the service clock cookie with the returned cookie. */
	
	TST_Error = DX_VOS_MemCmp(TST_return_cookie,TST_ServiceDes.cookie,sizeof(TLK_SCLK_Cookie_t));
    if (TST_Error != 0)
	{
		ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n!!!! TST_Error - TLK_SCLK_ServiceClkAuthenticate\n"));
		ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - invalidate returned cookie\n"));
		return TST_FAIL;
	}

	/*  b. Compare the service clock offset with the returned offset. */
	
	if(TST_serviceClkOffset_ptr != TST_ServiceDes.offsetInSeconds)
	{
		ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n!!!! TST_Error - TLK_SCLK_ServiceClkAuthenticate\n"));
		ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - invalidate returned offset\n"));
		return TST_FAIL;
	}	

	ATP_LOG_TST_PRINT((MW_ATP_MSG," **********************************************\n\n"));
	ATP_LOG_TST_PRINT((MW_ATP_MSG," ** TLK_SCLK_ATP_Authenticate  Test  PASS !!! \n"));     
	ATP_LOG_TST_PRINT((MW_ATP_MSG," ********************************************** \n \n"));

	return TST_PASS;
    
   EXIT_ON_ERROR:
	{
	return DX_FAILURE;
	}
}










